// Common Header
#pragma rtGlobals=3
#pragma rtFunctionErrors=1
#pragma IgorVersion=9
#pragma TextEncoding="UTF-8"
#pragma hide = 1

// Procedure Loader Hide

// Module Name
#pragma ModuleName=SpXZgRLayout

// Specific Parameters
StrConstant k_SpXZgRLayoutPanelName = "SpXZeigRLayoutPanel"
Constant k_SpXZgRGrpwidth = 220
Constant k_SpXZgRGrpheight = 440
Static Constant k_delcontrola = 25
Static Constant k_delcontrolb = 20
Static Constant k_delcontrolc = 15

// @brief primary entrance to attach panel to front graph
Function attach_SpXZeigRPanel()

	string fWin = WinName(0,1,1)	

	initialize_SpXZeigR()
	string mWin = SpXZgR_findChildPanel(k_SpXZgRLayoutPanelName,"",main=1)
	if (strlen(mWin)!=0)
		DoWindow/F $mWin
		KillWindow/Z $k_SpXZgRLayoutPanelName
	endif
	DoWindow/F $fWin
	add_ControlPaneltoGraph(dfSTn=1,dfGMn=1,dfTSn=1)
	return 0
end

// @breif add Layout Control Panel to Graph
Static Function add_ControlPaneltoGraph([variable dfSTn, variable dfGMn, variable dfTSn])
	
	variable px = 10
	variable py = 10

	NewPanel/EXT=0/HOST=#/K=1/N=$k_SpXZgRLayoutPanelName/W=(0,k_SpXZgRGrpheight,k_SpXZgRGrpwidth,k_SpXZgRGrpheight) as "SpXZeigR Layout"

	// settings
	
	Button settings_cb, pos={k_SpXZgRGrpwidth-25,py}, size={15,15}, title="", picture=ProcGlobal#SpXZgR_pCog
	Button settings_cb, proc=cbc_SpXZgRLayout, help={"access settings for layout panel"}

	// graph style
	TitleBox tbgraph_cb title="Graph Design",pos={px,py},frame=0,fSize=14,fstyle=1

	py += k_delcontrola

	PopupMenu plotmode_cb,pos={px+5,py},size={120,25},title="Style",fSize=12, proc=cpu_SpXZgRLayout, help = {"set the graph style"}
	PopupMenu plotmode_cb,mode=1,value=#"SpXZeigRStyles#f_GraphModes()", popValue="Free"

	py += k_delcontrola

	// data type
	PopupMenu type_cb,pos={px+5,py},size={140,25},title="Data Type", fSize=12, proc=cpu_SpXZgRLayout, disable=2
	PopupMenu type_cb, mode=dfSTn, value=#"SpXZeigRStyles#f_SpectrumTypes()", popValue="Generic", help={"define the data type"}

	py += k_delcontrola
	
	TitleBox tbaxes_cb title="Axes Ranges",pos={px+5,py},frame=0,fSize=12 //,fstyle=1

	py += k_delcontrolc

	// axes
	PopupMenu axisleftmode_cb,pos={px+10,py},size={120,25},title="Left",fSize=12, proc=cpu_SpXZgRLayout, help={"set scaling for left axis\rnice or inset top only works with ticks on left axis"}
	PopupMenu axisleftmode_cb,value=SpXZeigRStyles#f_axesmodes(0), mode=1, userData="left"
	Checkbox visleft_cb, pos={k_SpXZgRGrpwidth-40,py}, title="[--]", size={20,20}, help={"scale to visible data only"}
	Checkbox visleft_cb, userData="left", proc=ccb_SpXZgRLayout

	py += k_delcontrolb

	PopupMenu axisbottommode_cb,pos={px+10,py},size={120,25},title="Bottom",fSize=12, proc=cpu_SpXZgRLayout, help={"set scaling for bottom axis\rnice or inset right only works with ticks on left axis"}
	PopupMenu axisbottommode_cb,value=SpXZeigRStyles#f_axesmodes(1), mode=1, userData="bottom"
	Checkbox visbottom_cb, pos={k_SpXZgRGrpwidth-40,py}, title="[--]", size={20,20}, help={"scale to visible data only"}
	Checkbox visbottom_cb, userData="bottom", proc=ccb_SpXZgRLayout

	py += k_delcontrola
	
	TitleBox tbdata_cb title="Geometry",pos={px+5,py},frame=0,fSize=12

	py += k_delcontrolc

	// graph aspect
	PopupMenu aspectratios_cb,pos={px+10,py},size={110,25},title="Aspect H/W",fSize=12, proc=cpu_SpXZgRLayout
	PopupMenu aspectratios_cb,mode=1,value=SpXZgRLayout#f_AspectRatios(), help={"set the aspect ratio of the graph"}

	py += k_delcontrolb
	
	// graph width
	Checkbox fixgraphsize_cb, pos={px+10, py}, size={20,20}, title="", proc=ccb_SpXZgRLayout, help={"keep the current size fixed"}
	SetVariable graphsize_cb, pos={px+30,py},size={146,25}, value=_NUM:20, title="Fix Larger (cm)", fSize=12
	SetVariable graphsize_cb, format="%3.1f", limits={1,inf,0.2}, disable=2, proc=csv_SpXZgRLayout, help={"define the fixed size of the larger axis"}

	// traces
	py += k_delcontrola
	
	SetDrawEnv linefgc=(52428,52428,52428)
	DrawLine 0, py, k_SpXZgRGrpwidth, py
	
	py += k_delcontrolc - 5
	
	TitleBox tbtracesdesign_cb title="Trace Design",pos={px,py},frame=0,fSize=14,fstyle=1

	// appearance

	py += k_delcontrola

	PopupMenu tracestyle_cb,pos={px+5,py},size={120,25},title="Style",fSize=12, proc=cpu_SpXZgRLayout, help={"set the style for all traces"}
	PopupMenu tracestyle_cb,mode=1,value=#"SpXZeigRStyles#f_TraceStyles()", popValue="Free"

	py += k_delcontrola
	
	Checkbox coloronoff_cb, pos={px+5,py}, title="", size={20,20}, fSize=10, value=0, proc=ccb_SpXZgRLayout, help={"enable or disable ability to change trace colors"}
	PopupMenu mtracecolor_cb, pos={px+25,py},size={120,25},title="Color",fSize=12, disable=2
	PopupMenu mtracecolor_cb, value="*COLORPOP*", proc=cpu_SpXZgRLayout, help={"set the color for all visible traces"}
	PopupMenu ftracecolor_cb, pos={px+25,py},size={120,25},title="Colors",fSize=12, disable=1
	PopupMenu ftracecolor_cb, value=SpXZgRLayout#f_LoColorVariations(), proc=cpu_SpXZgRLayout, help={"set how variations are made in colors for traces"}
	Checkbox freecolor_cb, pos={px+160,py}, title="Vary", size={20,20}, fSize=10, value=0, proc=ccb_SpXZgRLayout, disable=2, help={"allow colors to vary"}

	py += k_delcontrola

	// tags

	PopupMenu tagtraces_cb,pos={px+5,py},size={110,25},title="Tags",fSize=12, proc=cpu_SpXZgRLayout
	PopupMenu tagtraces_cb,mode=1,value="--;|<-;>|<;->|;", help={"add tags to traces"}
	Button nudgeTagsLeft_cb, pos={px+100,py}, size={20,20}, fSize=10, title="<"
	Button nudgeTagsLeft_cb, help={"nudge tags left"}, proc=cbc_SpXZgRLayout, disable=2
	Button nudgeTagsUp_cb, pos={px+121,py}, size={20,20}, fSize=10, title="^"
	Button nudgeTagsUp_cb, help={"nudge tags up"}, proc=cbc_SpXZgRLayout, disable=2
	Button nudgeTagsDown_cb, pos={px+144,py}, size={20,20}, fSize=10, title="v"
	Button nudgeTagsDown_cb, help={"nudge tags down"}, proc=cbc_SpXZgRLayout, disable=2
	Button nudgeTagsRight_cb, pos={px+165,py}, size={20,20}, fSize=10, title=">"
	Button nudgeTagsRight_cb, help={"nudge tags right"}, proc=cbc_SpXZgRLayout, disable=2
	
	py += k_delcontrola
	
	SetDrawEnv linefgc=(52428,52428,52428)
	DrawLine 0, py, k_SpXZgRGrpwidth, py
	
	py += k_delcontrolc - 5
	
	TitleBox tbtracesposition_cb title="Trace Positions",pos={px,py},frame=0,fSize=14,fstyle=1

	Checkbox normtraces_cb, pos={k_SpXZgRGrpwidth-90,py}, title="Normalize", size={20,20}, fSize=12
	Checkbox normtraces_cb, proc=ccb_SpXZgRLayout, disable=2, help={"normalize the display of traces (not the raw data)"}

	// positioning

	py += k_delcontrolb
	
	PopupMenu traceyoffsets_cb, pos={px+5,py},size={120,25},title="ΔY Offsets",fSize=12, help={"set how (vertical) offsets are applied to traces"}
	PopupMenu traceyoffsets_cb, mode=1, value="Free;\\M1(-;None;Fraction;Aligned;", proc=cpu_SpXZgRLayout

	py += k_delcontrolb

	SetVariable fracyoffset_cb, pos={px+125,py}, size={60,25}, value=_NUM:0, disable=1, help={"set the fractional offset between traces"}
	SetVariable fracyoffset_cb, format="%3.2f",limits={-inf,inf,0.1},fSize=12, proc=csv_SpXZgRLayout

	SetVariable cursorx_cb, pos={px+10,py}, size={100,25}, format="%3.1f", value=_NUM:NaN
	SetVariable cursorx_cb, fSize=12, disable=1, title="csr X", help={"defines the x position of the cursor"}

	PopupMenu aligny_cb, pos={px+122,py},size={120,25},title="",fSize=12, proc=cpu_SpXZgRLayout
	PopupMenu aligny_cb, mode=1, value="|<;(csr);>|;", help={"align traces at left edge, cursor position, or right edge"}, disable=1

	// visible
	py += k_delcontrola	
	
	PopupMenu traceVisible_cb, pos={px+5,py},size={120,25},fSize=12,title="Visible", help={"set which traces are visible\rmatch uses wildcard string"}
	PopupMenu traceVisible_cb, mode=1, value="All;One;Match;Match/1;", proc=cpu_SpXZgRLayout
	SetVariable traceNum_cb, pos={px+130,py},title="",fSize=12,limits={0,1,2},value=_NUM:0
	SetVariable traceNum_cb, proc=csv_SpXZgRLayout,disable=1, help={"step through the traces to show one at a time"}

	py += k_delcontrolb	
	SetVariable traceStr_cb, pos={px+10,py}, size={160,25}, fSize=12, title="string", help={"define which traces are visible by a match string"}
	SetVariable traceStr_cb, disable=1, value=_STR:"*", proc=csv_SpXZgRLayout

	SetWindow $k_SpXZgRLayoutPanelName, hook(SpXZgRHF)=hf_SpXZgRPanel
	return 0
end

// @brief choose aspect ratios for graph
// @return possible aspect ratios
Static Function/S f_AspectRatios()

	string rstr = "Free;1:1;1:2;2:3;3:4;3:5;9:16;2:1;3:2;4:3;5:3;16:9;"
	return rstr
end

// @brief choose colors for traces
// @return list of color options
Static Function/S f_LoColorVariations()

	string srtn = "Manual;RGB;Rainbow;"
	
	if (strlen(FunctionInfo("ColorByIndex#do_cmd","ColourTracesByIndex"))!=0)
		srtn += "by Index;"
	else
		srtn += "\\M1(by Index;"
	endif
	
	return srtn
end

// @brief hook function for main panel
Function hf_SpXZgRPanel(STRUCT WMWinHookStruct &hs)
	
	variable hookResult = 0
	string theWin
	switch(hs.eventCode)
		case 2:			// kill panel
			remove_Ccsr()
			hookResult = 1
			break
		default:
			break
	endswitch

	return hookResult
end	

// @brief hook function for layout graph
Function hf_SpXZgRLayout(STRUCT WMWinHookStruct &hs)
	
	variable hookResult = 0
	switch(hs.eventCode)
		case 7:			// cursor moved
			strswitch (hs.cursorName)
				case "C":
					align_tracesatCsr(hs.pointNumber)
					hookResult = 1
					break
				default:
					break		
			endswitch
			break
		default:
			break
	endswitch

	return hookResult
end	

// @brief duplicates graph to use only the visible traces
Static Function duplicate_withvisibleTraces()

	string gWin, vtList, theTrace
	DoIgorMenu "Edit", "Duplicate"
	gWin = WinName(0,1)
	GetWindow $gWin, wtitle
	DoWindow/T $gWin, s_value+" duplicated"
	vtList = RemoveFromList(TraceNameList(gWin,";",1+4),TraceNameList(gWin,";",1))
	wave/T ht = ListToTextWave(vtList,";")
	for (theTrace : ht)
		RemoveFromGraph/W=$gWin, $theTrace
	endfor
	return 0
end

// @brief change aspect ratio of graph
// "Free;1:1;1:2:2:3;3:4;3:5;9:16;2:1;3:2;4:3;5:3;16:9;"
Static Function change_WindowAspect(variable value)
	
	string theWin = WinName(0,1,1)
	variable ww, wh, vcm
	
	ModifyGraph/W=$theWin height=0, width=0

	if (value == 1)		// free
		Checkbox fixgraphsize_cb, win=$k_SpXZgRLayoutPanelName, disable=1, value=0
		SetVariable graphsize_cb, win=$k_SpXZgRLayoutPanelName, disable=1, value=_NUM:NaN
	else		// any fixed value
		Checkbox fixgraphsize_cb, win=$k_SpXZgRLayoutPanelName, disable=0
		SetVariable graphsize_cb, win=$k_SpXZgRLayoutPanelName, disable=0
		ControlInfo/W=$k_SpXZgRLayoutPanelName fixgraphsize_cb
		fix_GraphSize(v_value)
		update_GraphSize()
	endif

	switch(value)
		case 1:		// free
			break
		case 2:		// 1:1
			ModifyGraph/W=$theWin height={Aspect,1}
			break
		case 3:		// 1:2
			ModifyGraph/W=$theWin height={Aspect,0.5}
			break
		case 4:		// 2:3
			ModifyGraph/W=$theWin height={Aspect,0.667}
			break
		case 5:		// 3:4
			ModifyGraph/W=$theWin height={Aspect,0.75}
			break
		case 6:		// 3:5
			ModifyGraph/W=$theWin height={Aspect,0.6}
			break
		case 7:		// 9:16
			ModifyGraph/W=$theWin height={Aspect,0.5625}
			break
		case 8:		// 2:1
			ModifyGraph/W=$theWin width={Aspect,0.5}
			break
		case 9:		// 3:2
			ModifyGraph/W=$theWin width={Aspect,0.667}
			break
		case 10:		// 4:3
			ModifyGraph/W=$theWin width={Aspect,0.75}
			break
		case 11:		// 5:3
			ModifyGraph/W=$theWin width={Aspect,0.6}
			break
		case 12:		// 16:9
			ModifyGraph/W=$theWin width={Aspect,0.5625}
			break
		default:
			break
	endswitch

	return 0
end

// @brief update the graph size display
Static Function update_GraphSize()

	variable vcm, ww, wh, woh
	string theWin = WinName(0,1,1)
	GetWindow $theWin psize
	ww = (v_right - v_left)
	wh = (v_bottom - v_top)
	vcm = 2.54*max(ww,wh)/72
	SetVariable graphsize_cb, win=$k_SpXZgRLayoutPanelName, value=_NUM:vcm

	return 0
end

// @brief set graph size; how=0 free, how=1 fixed
Static Function fix_GraphSize(variable how)

	variable vcm, ww, wh, woh
	string theWin
	
	ControlInfo/W=$k_SpXZgRLayoutPanelName aspectratios_cb
	woh = v_value
	theWin = WinName(0,1,1)
	
	switch(how)
		case 0:		// not fixed
			SetVariable graphsize_cb, win=$k_SpXZgRLayoutPanelName, disable=2
			if (woh < 6)
				ModifyGraph/W=$theWin width=0
			else
				ModifyGraph/W=$theWin height=0
			endif
			break
		case 1:		// fixed by current
			SetVariable graphsize_cb, win=$k_SpXZgRLayoutPanelName, disable=0
			GetWindow $theWin psize
			ww = (v_right - v_left)
			wh = (v_bottom - v_top)
			vcm = 2.54*max(ww,wh)/72
			if (woh < 6)
				ModifyGraph/W=$theWin width=ww
			else
				ModifyGraph/W=$theWin height=wh
			endif
			update_GraphSize()
			break
		case 2:		// fixed with input
			ControlInfo/W=$k_SpXZgRLayoutPanelName graphsize_cb
			ww = v_value*72/2.54
			if (woh < 6)
				ModifyGraph/W=$theWin width=ww
			else
				ModifyGraph/W=$theWin height=ww
			endif
			break
		default:
			break
	endswitch
	return 0
end

// @breif lock axis mode
Static Function set_AxisLockMode(string whichone)
	
	string theWin = WinName(0,1,1)
	strswitch(whichone)
		case "left":
			GetAxis/W=$theWin/Q left			
			SetAxis/W=$theWin left v_min, v_max
			CheckBox visleft_cb, win=$k_SpXZgRLayoutPanelName, disable=2
			break
		case "bottom":
			GetAxis/W=$theWin/Q bottom			
			SetAxis/W=$theWin bottom v_min, v_max
			CheckBox visbottom_cb, win=$k_SpXZgRLayoutPanelName, disable=2
			break
		default:
			break
	endswitch
	
	return 0
end

// @brief set axis auto mode or lock mode
// @input
// state: 0 autoscale full, 1 autoscale nice, 3 autoscale + inset
// state: 3 autoscale nice top only, 4 autoscale + inset top only
Static Function set_AxisAutoMode(string whichone, variable state)
	
	string theWin = WinName(0,1,1)
	strswitch(whichone)
		case "left":
			switch(state)
				case 0:	// fallthrough
				case 1:	// fallthrough
				case 2:	// fallthrough autoscale full, nice, inset
					ControlInfo/W=$k_SpXZgRLayoutPanelName visleft_cb
					SetAxis/W=$theWin/A=(v_value+1)/N=(state) left
					CheckBox visleft_cb, win=$k_SpXZgRLayoutPanelName, disable=0
					break
				default:
					ControlInfo/W=$k_SpXZgRLayoutPanelName visleft_cb 
					SetAxis/W=$theWin/A=(v_value+1)/N=0 left
					DoUpdate/W=$theWin
					GetAxis/W=$theWin/Q left
					SetAxis/W=$theWin/A=(v_value+1)/N=(state-2) left, v_min, *
					CheckBox visleft_cb, win=$k_SpXZgRLayoutPanelName, disable=0
					break
			endswitch
			break
		case "bottom":
			switch(state)
				case 0:	// fallthrough
				case 1:	// fallthrough
				case 2:	// fallthrough autoscale full, nice, inset
					ControlInfo/W=$k_SpXZgRLayoutPanelName visbottom_cb
					SetAxis/W=$theWin/A=(v_value+1)/N=(state) bottom
					CheckBox visbottom_cb, win=$k_SpXZgRLayoutPanelName, disable=0
					break
				default:
					ControlInfo/W=$k_SpXZgRLayoutPanelName visbottom_cb 
					SetAxis/W=$theWin/A=(v_value+1)/N=0 bottom
					DoUpdate/W=$theWin
					GetAxis/W=$theWin/Q bottom
					if (v_min > v_max)
						SetAxis/W=$theWin/A=(v_value+1)/N=(state-2) bottom, v_max, *
					else
						SetAxis/W=$theWin/A=(v_value+1)/N=(state-2) bottom, v_min, *
					endif
					CheckBox visbottom_cb, win=$k_SpXZgRLayoutPanelName, disable=0
					break
			endswitch
		default:
			break
	endswitch

	return 0
end

// @brief change trace color
Static Function change_TraceColor(string rgbstr, [string theTrace])

	string theCmd
	if (ParamIsDefault(theTrace))
		wave/T tList = ListToTextWave(TraceNameList(WinName(0,1),";",1+4),";")
		theCmd = "ModifyGraph "
		for (theTrace : tList)
			sprintf theCmd, "%s rgb(%s)=%s,", theCmd, theTrace, rgbstr
		endfor
		theCmd = RemoveEnding(theCmd)
	else
		sprintf theCmd, "ModifyGraph rgb(%s)=%s" theTrace, rgbstr
	endif
	Execute theCmd
	return 0
end

// @brief cycle colors on traces
Static Function cycle_TraceColors(variable how)

	string theList, theColor, gWin
	string rgbbList = "(0,0,0);(1,4,52428);(1,26214,0);(39321,1,1);"
	variable ic, ntraces, rgbi, rgbidelta
	
	gWin = WinName(0,1,1)
#if Exists("ColorByIndex#do_cmd")
	ColorByIndex#do_cmd("Kill Panel")
#endif

	switch(how)
		case 1:		// manual
			break
		case 2:		// BBGR
			theList=TraceNameList(gWin,";",1+4)
			ntraces = ItemsInList(theList)
			wave/T traceNames = ListToTextWave(theList,";")			
			for (ic=0;ic<ntraces;ic+=1)
				theColor = StringFromList(mod(ic,4),rgbbList)
				change_TraceColor(theColor, theTrace=traceNames[ic])
			endfor
			break
		case 3:		// rainbow
			ColorTab2Wave Igor
			wave M_colors
			theList=TraceNameList(gWin,";",1+4)
			ntraces = ItemsInList(theList)
			rgbidelta = floor(128/ntraces)-1
			wave/T traceNames = ListToTextWave(theList,";")			
			for (ic=0;ic<ntraces;ic+=1)
				rgbi = (ic*rgbidelta)+1
				sprintf theColor "(%d,%d,%d)", M_colors[rgbi][0], M_colors[rgbi][1], M_colors[rgbi][2]
				change_TraceColor(theColor, theTrace=traceNames[ic])
			endfor
			killwaves/Z M_colors
			break
		case 4:		// by Index
#if Exists("ColorByIndex#do_cmd")
			ColorByIndex#do_cmd("Append Panel")
#endif
			break
		default:
			break
	endswitch
	return 0
end

// @brief turn on/off color selection
Static Function enable_color(variable onoff)

	variable ntraces, vcolor, pstate
	ControlInfo/W=$k_SpXZgRLayoutPanelName freecolor_cb
	vcolor = v_value	
	switch(onoff)
		case 0:		// off
			if (vcolor == 0)
				PopupMenu mtracecolor_cb, win=$k_SpXZgRLayoutPanelName, disable=2
				PopupMenu ftracecolor_cb, win=$k_SpXZgRLayoutPanelName, disable=1
			else	
				PopupMenu mtracecolor_cb, win=$k_SpXZgRLayoutPanelName, disable=1
				PopupMenu ftracecolor_cb, win=$k_SpXZgRLayoutPanelName, disable=2
			endif
			Checkbox freecolor_cb, win=$k_SpXZgRLayoutPanelName, disable=2
#if Exists("ColorByIndex#do_cmd")
			ColorByIndex#do_cmd("Kill")
#endif
			break
		case 1:		// on
			ntraces = ItemsInList(TraceNameList("",";",1+4))
			if (ntraces > 1)
				Checkbox freecolor_cb, win=$k_SpXZgRLayoutPanelName, disable=0
				if (vcolor == 0)
					PopupMenu mtracecolor_cb, win=$k_SpXZgRLayoutPanelName, disable=0
					PopupMenu ftracecolor_cb, win=$k_SpXZgRLayoutPanelName, disable=1
				else	
					PopupMenu mtracecolor_cb, win=$k_SpXZgRLayoutPanelName, disable=1
					PopupMenu ftracecolor_cb, win=$k_SpXZgRLayoutPanelName, disable=0
				endif						
			else
				Checkbox freecolor_cb, win=$k_SpXZgRLayoutPanelName, disable=2, value=0
				PopupMenu mtracecolor_cb, win=$k_SpXZgRLayoutPanelName, disable=2
				PopupMenu ftracecolor_cb, win=$k_SpXZgRLayoutPanelName, disable=1
			endif
			break
		default:
			break
	endswitch
	
	return 0
end

// @brief switch between mono and free color modes
Static Function switch_MonoFreeColor(variable dofree)
	
	PopupMenu mtracecolor_cb, win=$k_SpXZgRLayoutPanelName, disable=(dofree)
	PopupMenu ftracecolor_cb, win=$k_SpXZgRLayoutPanelName, disable=(!dofree)
	if (!dofree)
		ControlInfo/W=$k_SpXZgRLayoutPanelName mtracecolor_cb
#if Exists("ColorByIndex#do_cmd")
		ColorByIndex#do_cmd("Kill Panel")
#endif
		change_TraceColor(S_value)
	else
		ControlInfo/W=$k_SpXZgRLayoutPanelName ftracecolor_cb
		cycle_TraceColors(v_value)
	endif
	return 0
end

// @brief normalize traces
Static Function normalize_traces(variable onoff)

	DFREF pf = $(k_SpXZgRPackageFolder + ":globals")

	wave/SDFR=pf yo, yf, dy
	NVAR/SDFR=pf dymax

	string theWin = WinName(0,1,1)
	string theOne
	variable ic, ntraces, fraction, yoi, dyc
	
	duplicate/FREE dy sf
	sf = 1
	
	generate_traceyranges()

	ControlInfo/W=$k_SpXZgRLayoutPanelName traceyoffsets_cb
	switch(v_value)
		case 3:		// none
			wave/T traceList = ListToTextWave(TraceNameList(theWin,";",1),";")
			ntraces = DimSize(traceList,0)
			if (onoff)
				for (ic=0;ic<ntraces;ic++)
					theOne = traceList[ic]
					ModifyGraph/W=$theWin muloffset($theOne)={0,1/(dy[ic]*sf[ic])}
				endfor
			else
				ModifyGraph/W=$theWin muloffset={0,0}
			endif
			break
		case 4:		// fraction
			wave/T traceList = ListToTextWave(TraceNameList(theWin,";",1),";")
			ntraces = DimSize(traceList,0)
			ControlInfo/W=$k_SpXZgRLayoutPanelName fracyoffset_cb
			fraction = v_value
			if (onoff)
				for (ic=0;ic<ntraces;ic++)
					theOne = traceList[ic]
					ModifyGraph/W=$theWin offset($theOne)={0,(-(yo[ic]/dy[ic]) + (ic*fraction*sf[ic]))}, muloffset($theOne)={0,1/(dy[ic]*sf[ic])}
				endfor
			else
				theOne = traceList[0]
				ModifyGraph/W=$theWin offset($theOne)={0,0}, muloffset($theOne)={0,0}
				for (ic=1;ic<ntraces;ic++)
					yoi = (yo[0] - yo[ic])
					dyc += fraction*dy[ic-1]*sf[ic]
					theOne = traceList[ic]
					ModifyGraph/W=$theWin offset($theOne)={0,yoi+dyc}, muloffset($theOne)={0,0}
				endfor
			endif
			break
		case 5:		// align
			ControlInfo/W=$k_SpXZgRLayoutPanelName aligny_cb
			align_Traces("left",v_value)
		default:
			break
	endswitch
	return 0
end

// @brief get axis command
Static Function/S get_AxisCommand(string whichone)

	string astr, rstr, gstr
	gstr = "SETAXISCMD:SetAxis*"
	astr = AxisInfo("",whichone)
	rstr = RemoveEnding(GrepList(astr,gstr))
	rstr = RemoveListItem(0,rstr,":")
	return rstr
end

// @brief remove the C cursor from the top graph
Static Function remove_Ccsr()

	string theWin = WinName(0,1,1)
	SetWindow $theWin, hook(SpXZgRHF)=$""
	Cursor/K/W=$theWin C
	return 0
end

// @brief change trace offsets
// @input: axis - left, bottom; mode - 1 free, 3 none, 4 fraction, 5 at cursor
Static Function change_TraceOffsets(string axis, variable mode)

	string theWin
	
	strswitch(axis)
		case "left":
			remove_Ccsr()
			switch(mode)
				case 1:		// free
					SetVariable fracyoffset_cb, win=$k_SpXZgRLayoutPanelName, disable=1
					SetVariable cursorx_cb, win=$k_SpXZgRLayoutPanelName, disable=1
					PopupMenu aligny_cb, win=$k_SpXZgRLayoutPanelName, disable=1
					Checkbox normtraces_cb, win=$k_SpXZgRLayoutPanelName, disable=2
					break
				case 3:		// no offset
					SetVariable fracyoffset_cb, win=$k_SpXZgRLayoutPanelName, disable=1
					SetVariable cursorx_cb, win=$k_SpXZgRLayoutPanelName, disable=1
					PopupMenu aligny_cb, win=$k_SpXZgRLayoutPanelName, disable=1
					Checkbox normtraces_cb, win=$k_SpXZgRLayoutPanelName, disable=0
					theWin = WinName(0,1,1)
					ModifyGraph/W=$theWin offset={0,0}
					break
				case 4:		// fraction
					SetVariable fracyoffset_cb, win=$k_SpXZgRLayoutPanelName, disable=0
					SetVariable cursorx_cb, win=$k_SpXZgRLayoutPanelName, disable=1
					PopupMenu aligny_cb, win=$k_SpXZgRLayoutPanelName, disable=1
					Checkbox normtraces_cb, win=$k_SpXZgRLayoutPanelName, disable=0
					ControlInfo/W=$k_SpXZgRLayoutPanelName fracyoffset_cb
					offset_Traces("left", v_value)
					break
				case 5:		// align
					SetVariable fracyoffset_cb, win=$k_SpXZgRLayoutPanelName, disable=1
					PopupMenu aligny_cb, win=$k_SpXZgRLayoutPanelName, userData="", disable=0
					Checkbox normtraces_cb, win=$k_SpXZgRLayoutPanelName, disable=0
					ControlInfo/W=$k_SpXZgRLayoutPanelName aligny_cb
					SetVariable cursorx_cb, win=$k_SpXZgRLayoutPanelName, disable=(2*(v_value==2))
					set_alignmode(v_value)
					break
				default:
					break
			endswitch
			break
		case "bottom":
			if (mode == 1)
				SetVariable fracxoffset_cb, win=$k_SpXZgRLayoutPanelName, value=_NUM:0, disable=1
				offset_Traces("bottom", 0)
			else
				SetVariable fracxoffset_cb, win=$k_SpXZgRLayoutPanelName, disable=0
			endif
			break
		default:
			break
	endswitch
	return 0
end

// @brief offset traces
// @inputs axes: left/bottom, fraction: -inf to +inf, fullset
Static Function offset_Traces(string axes, variable fraction, [variable fullset])

	DFREF pf = $(k_SpXZgRPackageFolder + ":globals")

	wave/SDFR=pf yo, yf, dy
	NVAR/SDFR=pf dymax

	string trList = TraceNameList("",";",1)
	string theWin = WinName(0,1,1)
	string theOne
	variable ic, yoi, normed, ypos
	variable ntraces = ItemsInList(trList)
	variable dyc = 0

	// get bottom axes range
	GetAxis/W=$theWin/Q bottom
	
	duplicate/FREE dy sf
	if (ParamIsDefault(fullset))
		sf = 1
	else
		sf = dy/dymax
	endif
	
	ControlInfo/W=$k_SpXZgRLayoutPanelName normtraces_cb
	normed = v_value
	wave/T traceList = ListToTextWave(trList,";")
	generate_traceyranges()
	switch(normed)
		case 0:		// not normalized
			theOne = traceList[0]
			ModifyGraph/W=$theWin offset($theOne)={0,0}, muloffset($theOne)={0,0}
			for (ic=1;ic<ntraces;ic+=1)
				yoi = (yo[0] - yo[ic])
				dyc += fraction*dy[ic-1]*sf[ic]
				theOne = traceList[ic]
				ModifyGraph/W=$theWin offset($theOne)={0,yoi+dyc}, muloffset($theOne)={0,0}
			endfor
			break
		case 1:		// normalized
			for (ic=0;ic<ntraces;ic+=1)
				theOne = traceList[ic]
				ModifyGraph/W=$theWin offset($theOne)={0,(-(yo[ic]/dy[ic]) + (ic*fraction*sf[ic]))}, muloffset($theOne)={0,1/(dy[ic]*sf[ic])}
			endfor
			break
		default:
			break
	endswitch
	return 0
end

// @brief generate the trace offsets
Static Function generate_traceyranges()

	DFREF pf = $k_SpXZgRPackageFolder
	SVAR/SDFR=pf/Z gWin
	
	string theList, theOne, theWin
	variable ic, ntraces
	
	theWin = WinName(0,1,1)
	theList = TraceNameList(theWin,";",1)
	ntraces = ItemsInList(theList)

	DFREF cdf = GetDataFolderDFR()
	SetDataFolder pf
	NewDataFolder/O/S globals
	Make/N=(ntraces)/D/O yo, yf, dy
	variable/G dymax, yomin
	string/G gWin = theWin

	wave/T traceList = ListToTextWave(theList,";")
	GetAxis/W=$theWin/Q bottom
	for (ic=0;ic<ntraces;ic+=1)
		theOne = traceList[ic]
		wave ww = TraceNameToWaveRef("",theOne)
		yo[ic] = wavemin(ww, v_min, v_max)
		yf[ic] = wavemax(ww, v_min, v_max)
	endfor
	dy = yf - yo
	dymax = wavemax(dy)
	yomin = wavemin(yo)
	SetDataFolder cdf

	return 0
end

// @brief set align traces mode
// @input how is popmenu choice
// 1 left, 2 cursor, 3 right
Static Function set_alignmode(variable how)
	
	string theWin, theOne
	variable setpnt
	
	theWin = WinName(0,1,1)
	theOne = StringFromList(0, TraceNameList(theWin,";",1))
	
	ModifyGraph/W=$theWin offset={0,0}, muloffset={0,0}
	SetVariable cursorx_cb, win=$k_SpXZgRLayoutPanelName, disable=(1 + (how==2))
	if (how == 2)
		GetAxis/W=$theWin/Q bottom
		setpnt = floor(v_min + ((v_max - v_min)/2))
		Cursor/S=0/H=2/T=2/W=$theWin C, $theOne, setpnt
		SetWindow $theWin, hook(SpXZgRHF)=hf_SpXZgRLayout
	else
		remove_Ccsr()
	endif
	
	align_Traces("left", how)

	return 0
end

// @brief align traces
// @inputs: axis - left only; where - 1 left, 2 cursor, 3 right
Static Function align_Traces(string axis, variable where)

	DFREF pf = $(k_SpXZgRPackageFolder + ":Globals")

	wave/SDFR=pf yo, yf, dy
	NVAR/SDFR=pf/Z dymax
	
	string trList = TraceNameList("",";",1)
	string theOne, theWin
	variable ic, vdy, pleft, pright, normed
	variable ntraces = ItemsInList(trList)
	
	theWin = WinName(0,1,1)
	
	// get bottom axes range
	GetAxis/W=$theWin/Q bottom
	if (v_min > v_max)
		pleft = 0
		pright = inf
	else
		pleft = inf
		pright = 0
	endif
	
	ControlInfo/W=$k_SpXZgRLayoutPanelName normtraces_cb
	normed = v_value
	wave/T traceList = ListToTextWave(trList,";")
	for (ic=0;ic<ntraces;ic+=1)
		theOne = traceList[ic]
		wave ww = TraceNameToWaveRef("",theOne)
		switch(where)
			case 1:	// left
				vdy = ww[pleft]
				break
			case 2:	// curs
				vdy = ww[x2pnt(ww,xcsr(C))]
				break
			case 3:	// right
				vdy = ww[pright]
				break
			default:
				break
		endswitch
		if (normed)
			ModifyGraph/W=$theWin offset($theOne)={0,-vdy/dy[ic]}, muloffset($theOne)={0,1/dy[ic]}
		else
			ModifyGraph/W=$theWin offset($theOne)={0,-vdy}, muloffset($theOne)={0,0}
		endif
	endfor
	
	return 0
end

// @brief align traces at cursor
Static Function align_TracesatCsr(variable pnt)

	DFREF pf = $(k_SpXZgRPackageFolder + ":Globals")

	wave/SDFR=pf yo, yf, dy
	NVAR/SDFR=pf/Z dymax

	string theOne
	string trList = TraceNameList("",";",1)
	variable ic, vdy, xc, normed
	variable ntraces = ItemsInList(trList)

	xc = xcsr(C)
	ControlInfo/W=$k_SpXZgRLayoutPanelName normtraces_cb
	normed = v_value
	SetVariable cursorx_cb, win=$k_SpXZgRLayoutPanelName, value=_NUM:xc
	wave/T traceList = ListToTextWave(trList,";")
	for (ic=0;ic<ntraces;ic+=1)
		theOne = traceList[ic]
		wave ww = TraceNameToWaveRef("",theOne)
		vdy = ww[x2pnt(ww,xc)]
		if (normed)
			vdy /= dy[ic]
		endif
		ModifyGraph offset($theOne)={0,-vdy}
	endfor

	return 0
end

// @brief tag traces on graph
// @input
// how: 0-clear, 1-left, 2-center, 3-right
Static Function tag_Traces(variable how)

	string theList, theOne, theTagN
	string theWin=WinName(0,1,1)
	variable ic, ntraces, dv
	variable fv=1
	
	theList = TraceNameList("",";",1)
	ntraces = ItemsInList(theList)
	GetAxis/W=$theWin/Q bottom
	dv = v_max - v_min
	switch(how)
		case 1:
			fv = 0
			break
		case 2:
			fv = v_min + 0.05*dv
			break
		case 3:
			fv = v_min + 0.5*dv
			break
		case 4:
			fv = v_min + 0.95*dv
			break
		default:
			break
	endswitch
	
	wave/T traceList = ListToTextWave(theList,";")
	for (ic=0;ic<ntraces;ic+=1)
		theOne = traceList[ic]
		theTagN = "tag"+CleanUpName(theOne,0)
		if (fv == 0)
			Tag/W=$theWin/K/N=$theTagN
		else
			Tag/W=$theWin/C/N=$theTagN/F=0/Z=1/A=MB/L=0/Y=0 $theOne, fv,"\\Z10\\On"
		endif
	endfor

	Button nudgetagsleft_cb, win=$k_SpXZgRLayoutPanelName, disable=(2*(how==1))
	Button nudgetagsright_cb, win=$k_SpXZgRLayoutPanelName, disable=(2*(how==1))
	Button nudgetagsup_cb, win=$k_SpXZgRLayoutPanelName, disable=(2*(how==1))
	Button nudgetagsdown_cb, win=$k_SpXZgRLayoutPanelName, disable=(2*(how==1))
	return 0
end

// @brief nudge tags
Static Function nudge_tags(string direction)

	variable loc, ic, ntags, vxoff, vyoff
	string gWin, aList, ainfo
	string atext, aflag, axoff, ayoff, tname
	
	gWin = WinName(0,1,1)
	aList = ListMatch(AnnotationList(gWin),"tag*")
	ntags = ItemsInList(aList)
	ainfo = AnnotationInfo(gWin,StringFromList(0,aList),0)
	aflag = StringByKey("FLAGS",ainfo)
	axoff = StringByKey("X",aflag,"=","/")
	ayoff = StringByKey("Y",aflag,"=","/")
	
	strswitch(direction)
		case "nudgetagsleft_cb":
			vxoff = str2num(axoff) - 2
			vyoff = str2num(ayoff)
			break
		case "nudgetagsright_cb":
			vxoff = str2num(axoff) + 2
			vyoff = str2num(ayoff)
			break
		case "nudgetagsup_cb":
			vxoff = str2num(axoff)
			vyoff = str2num(ayoff) + 2
			break
		case "nudgetagsdown_cb":
			vxoff = str2num(axoff)
			vyoff = str2num(ayoff) - 2
			break
		default:
			break
	endswitch
	
	wave/T wList = ListToTextWave(aList,";")
	for (ic=0;ic<ntags;ic+=1)
		tname = wList[ic]		
		Tag/C/N=$tname/X=(vxoff)/Y=(vyoff)
	endfor
	
	return 0
end

// set visible traces
Static Function set_visibletraces(variable how)

	variable nt
	string theWin=WinName(0,1)
	
	switch(how)
		case 1:		// all
			SetVariable traceNum_cb, win=$k_SpXZgRLayoutPanelName, disable=1, value=_NUM:0
			SetVariable traceStr_cb, win=$k_SpXZgRLayoutPanelName, disable=1, value=_STR:"*"
//			Button duplicateVTraces_cb, win=$k_SpXZgRLayoutPanelName, disable=1
			ModifyGraph/W=$theWin hideTrace=0 
//			SetWindow $theWin, hook(SpXZgRHF)=hf_SpXZgRPanel
			break
		case 2:		// only one
			nt = hide_allbuttrace(0)
			SetVariable traceNum_cb, win=$k_SpXZgRLayoutPanelName, disable=0, value=_NUM:0, limits={0,nt,1}
			SetVariable traceStr_cb, win=$k_SpXZgRLayoutPanelName, disable=1, value=_STR:"*"
//			Button duplicateVTraces_cb, win=$k_SpXZgRLayoutPanelName, disable=0
//			SetWindow $theWin, hook(SpXZgRHF)=hf_SpXZgRPanel
			break
		case 3:		// by match string
			SetVariable traceNum_cb, win=$k_SpXZgRLayoutPanelName, disable=1, value=_NUM:0
			SetVariable traceStr_cb, win=$k_SpXZgRLayoutPanelName, disable=0, value=_STR:"*"
//			Button duplicateVTraces_cb, win=$k_SpXZgRLayoutPanelName, disable=0
			ModifyGraph/W=$theWin hideTrace=0 
//			SetWindow $theWin, hook(SpXZgRHF)=hf_SpXZgRPanel
			break
		case 4:		// by match string + one
			SetVariable traceNum_cb, win=$k_SpXZgRLayoutPanelName, disable=0, value=_NUM:0
			SetVariable traceStr_cb, win=$k_SpXZgRLayoutPanelName, disable=0, value=_STR:"*"
//			Button duplicateVTraces_cb, win=$k_SpXZgRLayoutPanelName, disable=0
			ModifyGraph/W=$theWin hideTrace=0 
//			SetWindow $theWin, hook(SpXZgRHF)=hf_SpXZgRPanel
			break
		default:
			break
	endswitch
	
	return 0
end

// @brief hide all but a specific trace
Static Function hide_allbuttrace(variable whichone)

	string theWin = WinName(0,1)
	string tList = TraceNameList(theWin,";",1)
	string tName, sList
	variable nT
	
	ControlInfo/W=$k_SpXZgRLayoutPanelName traceVisible_cb
	switch(v_value)
		case 4:		// match + one
			ControlInfo/W=$k_SpXZgRLayoutPanelName traceStr_cb
			sList = ListMatch(tList,s_value)
			nt = ItemsInList(sList)-1
			tName = StringFromList(whichone,sList)
			break
		default:
			tName = StringFromList(whichone,tList)
			nt = ItemsInList(tList)-1
			break
	endswitch
	ModifyGraph/W=$theWin hideTrace=1
	ModifyGraph/W=$theWin hideTrace($tName)=0
	SetVariable traceNum_cb, win=$k_SpXZgRLayoutPanelName, limits={0,nt,1}
	return nt
end

// @brief show and handle settings for layout panel
Static Function SpXZgR_LayoutSettings()

	string cmdstr = "Reload All Styles;"
	ControlInfo traceVisible_cb
	if (v_value > 1)
		cmdstr += "Duplicate Visible;"
	else
		cmdstr += "(Duplicate Visible;"
	endif
	PopupContextualMenu cmdstr
	switch(v_flag)
		case 1:	// reload all styles
			SpXZgR_ReloadStyles()
			break
		case 2:	// duplicate visible
			duplicate_withvisibleTraces()
			set_visibletraces(1)
			break
		default:
			break
	endswitch
	return v_flag
end

// @brief reload styles
Static Function SpXZgR_ReloadStyles()

	SpXZeigRStyles#load_SpXZgRstyles(reload=1)
	print "Reloaded SpXZeigR layout styles", Date(), Time()
	return 0
end

// @brief Button Controls
Function cbc_SpXZgRLayout(STRUCT WMButtonAction &ba) : ButtonControl

	switch( ba.eventCode )
		case 2: // mouse up
			strswitch(ba.ctrlName)
				// keep this here to handle older method
				case "removepanel_cb":
					KillWindow/Z $ba.win
					break
				case "settings_cb":
					SpXZgR_LayoutSettings()
					break
				case "nudgetagsleft_cb":		// fallthrough
				case "nudgetagsright_cb":		// fallthrough
				case "nudgetagsup_cb":			// fallthrough
				case "nudgetagsdown_cb":
					nudge_tags(ba.ctrlName)
					break
				default:
					break
			endswitch
			break
		default:
			break
	endswitch

	return 0
end

// @brief Popup Menu Control
Function cpu_SpXZgRLayout(STRUCT WMPopupAction &pa) : PopupMenuControl

	switch( pa.eventCode )
		case 2: // mouse up
			if (!SpXZgR_PopHasChanged(pa))
				return 0
			endif
			strswitch(pa.ctrlName)
				case "plotmode_cb":	// fallthrough
				case "type_cb":		// fallthrough
					SpXZeigRStyles#design_Graph()
					break
				case "axisleftmode_cb":
					if (pa.popNum == 6)
						set_AxisLockMode("left")
					else
						set_AxisAutoMode("left", pa.popNum-1)
					endif
					break
				case "axisbottommode_cb":
					if (pa.popNum == 6)
						set_AxisLockMode("bottom")
					else
						set_AxisAutoMode("bottom", pa.popNum-1)
					endif
					break
				case "aspectratios_cb":
					change_WindowAspect(pa.popNum)
					break
				case "tracestyle_cb":
					if (pa.popNum != 1)
						SpXZeigRStyles#change_traceStyle(pa.popNum)
					endif
					break
				case "mtracecolor_cb":
					change_TraceColor(pa.popStr)
					break
				case "ftracecolor_cb":
					cycle_TraceColors(pa.popNum)
					break
				case "tagtraces_cb":
					tag_Traces(pa.popNum)
					break
				case "traceyoffsets_cb":
					change_TraceOffsets("left", pa.popNum)
					break
				case "aligny_cb":
					set_alignmode(pa.popNum)
					break
				case "traceVisible_cb":
					set_visibletraces(pa.popNum)
					break
				default:
					break
			endswitch
			break
		default:
			break
	endswitch

	return 0
end

// @brief check box control
Function ccb_SpXZgRLayout(STRUCT WMCheckboxAction &cba) : CheckBoxControl

	switch( cba.eventCode )
		case 2: // mouse up
			strswitch(cba.ctrlName)
				case "visleft_cb":			// to range left
					ControlInfo/W=$k_SpXZgRLayoutPanelName axisleftmode_cb
					if (v_value > 3)
						set_AxisLockMode("left")
					else
						set_AxisAutoMode("left",v_value-1)
					endif
					break
				case "fixgraphsize_cb":		// fix graph size
					fix_GraphSize(cba.checked)
					break
				case "visbottom_cb":		// to range bottom
					ControlInfo/W=$k_SpXZgRLayoutPanelName axisbottommode_cb
					if (v_value > 3)
						set_AxisLockMode("bottom")
					else
						set_AxisAutoMode("bottom",v_value-1)
					endif
					break
				case "coloronoff_cb":			// turn on/off color settings
					enable_color(cba.checked)
					break
				case "freecolor_cb":		// switch mono <-> free
					switch_MonoFreeColor(cba.checked)
					break
				case "normtraces_cb":		// normalize traces
					normalize_traces(cba.checked)
					break
				default:
					break
			endswitch
			break
		default:
			break
	endswitch

	return 0
end

// @brief set variable control
Function csv_SpXZgRLayout(STRUCT WMSetVariableAction &sva) : SetVariableControl

	switch( sva.eventCode )
		case 1: // fallthrough mouse up
		case 2: // fallthrough Enter key
		case 3: // fallthrough Live update
			strswitch(sva.ctrlName)
				case "fracyoffset_cb":
					offset_Traces("left", sva.dval)
					break
				case "graphsize_cb":
					fix_GraphSize(2)
					break
				case "traceNUM_cb":
					hide_allbuttrace(sva.dval)
					break
				case "traceStr_cb":
					hide_tracesbyName(sva.sval)
					break
				default:
					break
			endswitch
			break
		default:
			break
	endswitch

	return 0
end

// @brief hide traces by name
Static Function hide_tracesbyName(string mstr)

	string theWin=WinName(0,1)
	string tList, sList, theVis
	variable nT
	
	tList = TraceNameList(theWin,";",1)
	sList = ListMatch(tList,mstr)
	nT = ItemsInList(sList)
	if (nT > 0)
		wave/T tvis = ListToTextWave(sList,";")
		ModifyGraph/W=$theWin hideTrace=1
		ControlInfo/W=$k_SpXZgRLayoutPanelName traceVisible_cb
		switch(v_value)
			case 3:		// match string
				for (theVis : tvis)
					ModifyGraph/W=$theWin hideTrace($theVis)=0
				endfor
				break
			case 4:		// match string+one
				ControlInfo/W=$k_SpXZgRLayoutPanelName traceNum_cb
				theVis = tvis[v_value]
				ModifyGraph/W=$theWin hideTrace($theVis)=0
				break
			default:
				break
		endswitch
	endif
	return nt
end